% Finding roots of a 1-D implicit function
% Finds x_root where y(x_root) = 0

function [roots, kpeak, vel] = find_roots_ene(x, y, k)

y_shift = y(2:end);
x_shift = x(2:end);
kshift.horz = k.horz(2:end);
kshift.slant = k.slant(2:end);

count = 1;
for i=1:size(y,2)-1
    % Ignoring the non-degenerate peak
    if count==1 && y_shift(i)>y(i)
        continue;
    end

    if y(i)*y_shift(i)<0
        slope_ene = (y_shift(i) - y(i))/(x_shift(i) - x(i));
        roots(count) = x(i) - y(i)/slope_ene;
        
        % Horizontal
        slopek.horz = (y_shift(i) - y(i))/(kshift.horz(i) - k.horz(i));
        kpeak.horz(count) = k.horz(i) - y(i)/slopek.horz;
        
        vel.horz(count) = (x_shift(i) - x(i))/(kshift.horz(i) - k.horz(i));
        
        % Slanted
        slopek.slant = (y_shift(i) - y(i))/(kshift.slant(i) - k.slant(i));
        kpeak.slant(count) = k.slant(i) - y(i)/slopek.slant;
        
        vel.slant(count) = (x_shift(i) - x(i))/(kshift.slant(i) - k.slant(i));
        
        count = count + 1;
    end
end

end